create or replace package body tbicds.PCK_UTL_EXPORT_DATA is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/   
   /*get static data item*/
   function demoValue_STAT (
      pi_vVariableName                  in varchar2,
      pi_vVariableValue                 in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select item from stat_data_collection '
                ||'where collection_type = ''_'||pi_vVariableName||''' and collection_item_id = :P';
      execute immediate v_vSql into v_vValue using pi_vVariableValue;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get patient data with static data*/
   function demoValue_TBL (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000); 
   begin
      v_vSql := 'select wm_concat(s.item) '
                ||'from patient_'||pi_vVariableName||' t, stat_data_collection s '
                ||'where t.patient_id = :P '
                ||'and s.collection_type = ''_'||pi_vVariableName||''' '
                ||'and t.'||pi_vVariableName||'_ID = s.collection_item_id'; 
      execute immediate v_vSql into v_vValue using pi_vPatientID;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get socioeconomic data*/
   function demoValue_SE (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000); 
   begin
      v_vSql := 'select wm_concat(s.item) '
                ||'from patient_socioeconomic t, stat_data_collection s '
                ||'where t.patient_id = :P '
                ||'and s.collection_type = ''_'||pi_vVariableName||''' '
                ||'and t.'||pi_vVariableName||'_ID = s.collection_item_id';
      execute immediate v_vSql into v_vValue using pi_vPatientID;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;
   
   /*Get last response value*/
   function latestResponseValue (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2
   is
      v_vSql                               varchar2(4000);
      v_vValue                             varchar2(32767);
   begin
      v_vSql := 'select response_value '
                ||'from data_intake_responses t '
                ||'where patient_id = :P and mid = :M and tid = :T and qid = :Q '
                ||'and intake_id = ('
                ||'select max(intake_id) from data_intake_responses s '
                ||'where s.patient_id = t.patient_id and s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) ';
      execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nMID, pi_nTID, pi_nQID;

      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;
      
   /*Get last radio responcse value*/
   function latestResponseValue_Radio (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2
   is
      v_vSql                               varchar2(4000);
      v_vSql_SkipShow                      varchar2(4000);
      v_vValue                             varchar2(32767);
      v_nRID                               number;
      v_nTID                               number;
      v_nQID                               number;
      v_vSkipShow                          varchar2(128);
   begin
      v_vSql := 'select response_value, rid '
                ||'from data_intake_responses t '
                ||'where patient_id = :P and mid = :M and tid = :T and qid = :Q '
                ||'and intake_id = ('
                ||'select max(intake_id) from data_intake_responses s '
                ||'where s.patient_id = t.patient_id and s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) ';
      execute immediate v_vSql into v_vValue, v_nRID using pi_vPatientID, pi_nMID, pi_nTID, pi_nQID;

      if (regexp_like (v_vValue, 'other', 'i'))
      then
         v_vSql_SkipShow := 'select skip_show from intake_response where mid = :M and tid = :T and qid = :Q and rid = :R';
         execute immediate v_vSql_SkipShow into v_vSkipShow using pi_nMID, pi_nTID, pi_nQID, v_nRID;
         
         v_nTID := to_number(substr(regexp_substr(v_vSkipShow, 'TID[[:digit:]]+'), 4));
         v_nQID := to_number(substr(regexp_substr(v_vSkipShow, 'QID[[:digit:]]+'), 4));
         
         execute immediate v_vSql into v_vValue, v_nRID using pi_vPatientID, pi_nMID, v_nTID, v_nQID;
      end if;

      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get demographic variables*/
   function getDemoVariables (
      pi_vDataIncluded                  in varchar2,
      pi_vKey                           in varchar2
      ) return                             varchar2
   is
   
      v_vVariableList                      varchar2(32767);
      v_vVariable                          varchar2(128);
      v_vValue                             varchar2(4000);

      -- addVariable()
      procedure addVariable (
         pi_vDataIncluded                  in varchar2,
         pi_vVariable                      in varchar2,
         pi_vValue                         in varchar2,
         pio_vVariableList             in out varchar2
         )
      is
      begin
         if (instr(pi_vDataIncluded,','||pi_vVariable||',') > 0 or pi_vVariable = 'PATIENT_ID')
         then
            pio_vVariableList := pio_vVariableList||','||pi_vValue||' '||pi_vVariable;
         elsif (c_nShowNotIncluded = 1)
         then
            pio_vVariableList := pio_vVariableList||','||'null '||pi_vVariable;
         end if;
      end;
   begin
      v_vVariable := 'PATIENT_ID';
      v_vValue := 'D.PATIENT_ID';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      /*v_vVariable := 'DATE_COMPLETED';
      v_vValue := 'I.DATE_COMPLETED';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);*/

      v_vVariable := 'CITY';
      v_vValue := v_vVariable;
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'STATE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||'STATES'||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'POSTAL_CODE';
      v_vValue := v_vVariable;
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'DOB';
      v_vValue := 'ic_utl_sec.decryptdata('||v_vVariable||','''||pi_vKey||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'GENDER';
      v_vValue := 'ic_utl_sec.decryptdata('||v_vVariable||','''||pi_vKey||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'DUTY_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'PREFERRED_LANGUAGE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'ETHNICITY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_TBL('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'RACE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_TBL('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HAND_PREFERENCE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HIGHEST_GRADE_LEVEL';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'HIGHEST_GRADE'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HIGHEST_DEGREE_OBTAINED';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'HIGHEST_DEGREE'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'MARITAL_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'EMPLOYMENT_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'JOB_CLASS_CAT';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'JOB_CLASSIFICATION'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'PRIMARY_IMP';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue_Radio(d.patient_id, 3000, 1, 1)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'PRIMARY_IMP_DATE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue(d.patient_id, 3000, 1, 3)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'MCH_INJURY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue_Radio(d.patient_id, 3000, 1, 4)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'COMORBIDITY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue(d.patient_id, 3000, 1, 6)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      return v_vVariableList||' ';

   exception
      when others
      then
         return null;
   end;
   
   /*get where clause*/
   function getWhereclause (
      pi_vFilters                       in varchar2
      ) return                             varchar2
   is
      v_vWhereClause                       varchar2(4000);
      v_vDateFormat_Filter                 varchar2(30) := 'yyyymmdd';
      v_vTemp                              varchar2(4000);
      v_vFilter                            varchar2(4000);
      v_vValue                             varchar2(128);
      v_nPos                               number;
      v_bOutpatient                        boolean := false;                
      v_bInpatient                         boolean := false;                
      v_vClinicalStt                       varchar2(3);
      v_nProgram                           number := -1;
      v_nRegion                            number := -1;
      v_nSite                              number := -1;
   begin
      -- set where clause using filters
      v_vTemp := lower(pi_vFilters)||',';
      while (v_vTemp is not null)
      loop
         v_nPos := instr(v_vTemp, ',');
         v_vFilter := substr(v_vTemp, 1, v_nPos-1);
         v_vTemp := substr(v_vTemp, v_nPos+1);
         
         if (v_vFilter like 'start_date%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_vFilter := 'trunc(i.date_completed) >= to_date('''||v_vValue||''','''||v_vDateFormat_Filter||''')';
         
         elsif (v_vFilter like 'end_date%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_vFilter := 'trunc(i.date_completed) <= to_date('''||v_vValue||''','''||v_vDateFormat_Filter||''')';

         elsif (v_vFilter like 'region%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nRegion := v_vValue;
            v_vFilter := 'i.region_id = '||v_vValue;
         
         elsif (v_vFilter like 'site%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nSite := v_vValue;
            v_vFilter := 'i.site_id = '||v_vValue;
         
         elsif (v_vFilter like 'outpatient%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_bOutpatient := (v_vValue = '1');
            v_vFilter := null;
            
         elsif (v_vFilter like 'inpatient%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_bInpatient := (v_vValue = '1');
            v_vFilter := null;

         elsif (v_vFilter like 'program%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nProgram := v_vValue;
            v_vFilter := null;
         else
            v_vFilter := null;
         end if;
         
         if (v_vFilter is not null)
         then
            v_vWhereClause := v_vWhereClause||'and '||v_vFilter||' ';
         end if;
      end loop;                
      
      if (v_bOutpatient and v_bInpatient) or
         (not v_bOutpatient and not v_bInpatient)
      then
        v_vClinicalStt := '1,2';
      elsif v_bOutpatient and not v_bInpatient
      then
        v_vClinicalStt := '1';
      elsif not v_bOutpatient and v_bInpatient
      then
        v_vClinicalStt := '2';
      end if;
      
      --Program filter
      v_vWhereClause := v_vWhereClause      
                        ||'and exists(select 1 from pat_treatment_program t '
                        ||'where t.patient_id = d.patient_id '
                        ||'  and t.treatment_id in(select treatment_id '
                                                ||'from pat_treatment t1 '
                                                ||'where t1.patient_id = d.patient_id '
                                                ||'  and t1.treatment_type_id in('||v_vClinicalStt||')'
                                                ||'  and t1.region_id='||v_nRegion
                                                ||'  and t1.site_id='||v_nSite||') '
                        ||'  and t.cpa_id = (select cpa_id '
                                          ||'from CPA t1 '
                                          ||'where t1.region_id='||v_nRegion
                                          ||'  and t1.site_id='||v_nSite
                                          ||'  and t1.cpa_type_id='||v_nProgram||'))';
 
      
      --if (v_bOutpatient and not v_bInpatient)
      --then
      --   v_vWhereClause := v_vWhereClause
      --                     ||'and exists (select * from pat_treatment s '
      --                     ||'where s.treatment_type_id = 1 and s.patient_id = i.patient_id) ';
    --  
      --elsif (not v_bOutpatient and v_bInpatient)
      --then
        -- v_vWhereClause := v_vWhereClause
          --                 ||'and exists (select * from pat_treatment s '
            --               ||'where s.treatment_type_id = 2 and s.patient_id = i.patient_id) ';
     -- end if;
      
      return v_vWhereClause;

   exception
      when others
      then
         return null;
   end;

   /*Get response value*/
   function responseValue (
      pi_vPatientID                     in varchar2,
      pi_nIntakeID                      in number,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number,
      pi_nRID                           in number
      ) return                             varchar2
   is
      v_exNoModule                         exception;
      v_nExists                            number;
      v_vSql                               varchar2(4000);
      v_nDisplayType                       number;
      v_vValue                             varchar2(4000);
   begin
   
      begin
        v_vSql := 'select 1 from data_intake_responses '
                  ||'where patient_id = :P and intake_id = :I and mid = :M and rownum = 1 ';  
        execute immediate v_vSql into v_nExists using pi_vPatientID, pi_nIntakeID, pi_nMID;
      exception
        when no_data_found
        then
           v_nExists := 0;
           raise v_exNoModule;
        when others
        then
           v_nExists := 0;
      end;
   
   
      v_vSql := 'select response_value from data_intake_responses '
                ||'where patient_id = :P and intake_id = :I and mid = :M and tid = :T and qid = :Q and rid = :R and rownum = 1 ';
      execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nIntakeID, pi_nMID, pi_nTID, pi_nQID, pi_nRID;
   
      v_vSql := 'select display_type from intake_response where mid = :M and tid = :T and qid = :Q and rid = :R and rownum = 1';
      execute immediate v_vSql into v_nDisplayType using pi_nMID, pi_nTID, pi_nQID, pi_nRID;
      
      if (v_nDisplayType not in (3,4,22))
      then
         v_vValue := '1';
      end if;
      
      return v_vValue;
      
   exception
      when v_exNoModule
      then
         return ''; -- return blank if no module has been taken
      when no_data_found 
      then 
         return '0';
      when others
      then 
         return sqlerrm;
   end;
            
   /*generate CSV data*/
   procedure generateCsv (
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2
      )
   is
      v_vSql                               varchar2(32767);
      rd                                   exp_statistical_rpt%rowtype;                                   
      v_vDataIncluded                      varchar2(4000);
      rc                                   sys_refcursor;
      v_nCurID                             number;
      v_nColumnCount                       number := 0;
      v_sDescTab                           dbms_sql.desc_tab;
      v_vColumnValue                       varchar2(4000);
      v_nColumnValue                       number;
      v_dColumnValue                       date;
      v_vDateFormat                        varchar2(30) := 'YYYY/MM/DD HH24:MI:SS';
      v_vDelimiter                         varchar2(5) := ',';
      v_lData                              clob;
      v_nColumnIndex_PatientID             number := 0;
      v_nColumnIndex_IntakeID              number := 0;
      v_vPatientID                         varchar2(60);
      v_nIntakeID                          number;
      v_nCurrentMID                        number;
      v_vBuffer                            varchar2(32767);
      v_nLastRownum                        number;
      v_nFilterByMID                       number := 0;
      
      v_vMsg                               varchar2(4000);
         
      procedure appendToClob (
         pio_lData                     in out clob,
         pio_vBuffer                   in out varchar2,
         pi_vText                          in varchar2
         )
      is
      begin
         if (length(pio_vBuffer)+length(pi_vText) >= 32767)
         then
            pio_lData := pio_lData||pio_vBuffer||pi_vText;
            pio_vBuffer := null;
         else
            pio_vBuffer := pio_vBuffer||pi_vText;
         end if;
      end;
   begin
      -- get parameters
      v_vSql := 'select * from exp_statistical_rpt where request_id = :P0';
      execute immediate v_vSql into rd using pi_nRequestID;
      v_vDataIncluded := ','||upper(rd.data_included)||',';

      v_vSql := 'select 1 from dual where exists(select mid from intake_module t where active=1 and instr('''||v_vDataIncluded||''',t.MID) > 0)';
      begin
        execute immediate v_vSql into v_nFilterByMID;
      exception
        when others then
          v_nFilterByMID :=0;
      end;
      
      -- construct sql
      if v_nFilterByMID = 1 then
        v_vSql := 'select i.PATIENT_ID as PAT_ID, i.INTAKE_ID '
                  ||getDemoVariables(v_vDataIncluded, pi_vKey)
                  ||'from patient_demographics d, pat_pw_event_module i, pat_pw_event e '
                  ||'where d.patient_id = i.patient_id '
                  ||'and e.pat_pw_event_id = i.pat_pw_event_id and e.status = 2 '
                  ||'and exists (select * from data_intake r where r.patient_id = i.patient_id and r.intake_id = i.intake_id and r.mid = i.mid) '
                  ||'and case when instr('''||v_vDataIncluded||''',i.MID) > 0 then 1 else 0 end = 1 '
                  ||getWhereclause (rd.filters);
                  
        if (c_nShowLatestIntakeOnly = 1) 
        then
           v_vSql := v_vSql||'and i.intake_id = (select max(s.intake_id) from pat_pw_event_module s where s.patient_id = i.patient_id '
                     ||replace(getWhereclause (rd.filters), ' i.', ' s.')||') ';
        end if;
      else
        v_vSql := 'select i.PATIENT_ID as PAT_ID, i.INTAKE_ID '
                  ||getDemoVariables(v_vDataIncluded, pi_vKey)
                  ||'from patient_demographics d, pat_pw_event_module i, pat_pw_event e '
                  ||'where d.patient_id = i.patient_id '
                  ||'and e.pat_pw_event_id = i.pat_pw_event_id and e.status = 2 '
                  ||'and exists (select * from data_intake r where r.patient_id = i.patient_id and r.intake_id = i.intake_id and r.mid = i.mid) '
                  ||'and i.intake_id = (select max(s.intake_id) from pat_pw_event_module s where s.patient_id = i.patient_id '
                  ||replace(getWhereclause (rd.filters), ' i.', ' s.')||') '
                  ||getWhereclause (rd.filters);
      end if;            
      
      v_vSql := v_vSql||'order by i.patient_id, i.intake_id ';
      
      -- switch from native dynamic SQL to dbms_sql package
      open rc for v_vSql;
      v_nCurID := dbms_sql.to_cursor_number (rc);
      dbms_sql.describe_columns (v_nCurID, v_nColumnCount, v_sDescTab);

      -- define columns and set header in csv
      for i in 1..v_nColumnCount
      loop
         -- set column index for patient_id and intake_id
         if (v_sDescTab(i).col_name = 'PAT_ID')
         then
            v_nColumnIndex_PatientID := i;
         elsif (v_sDescTab(i).col_name = 'INTAKE_ID')
         then
            v_nColumnIndex_IntakeID := i;
         end if;
         
         -- define columns 
         if (v_sDescTab(i).col_type = 2)
         then
            dbms_sql.define_column (v_nCurID, i, v_nColumnValue);
         elsif (v_sDescTab(i).col_type = 12)
         then
            dbms_sql.define_column (v_nCurID, i, v_dColumnValue);
         else
            dbms_sql.define_column (v_nCurID, i, v_vColumnValue, 4000);
         end if;
            
         -- set column name header
         if (v_sDescTab(i).col_name not in ('PAT_ID','INTAKE_ID'))
         then
            appendToClob (v_lData, v_vBuffer, '"'||v_sDescTab(i).col_name||'"'||v_vDelimiter);
         end if;
      end loop;

      -- get the last rownum to 
      v_vSql := 'select max(rn) from vw_utl_rpt_intake_response '
                || case when (c_nShowNotIncluded != 1) then 'where instr('''||v_vDataIncluded||''','',''||mid||'','') >= 1' end;
      execute immediate v_vSql into v_nLastRownum;
      
      -- add instrument data column names
      v_nCurrentMID := 0;
      for r in (select * from vw_utl_rpt_intake_response
                 where instr(v_vDataIncluded,','||mid||',') >= case when (c_nShowNotIncluded = 1) then 0 else 1 end)
      loop
         if (v_nCurrentMID != r.mid)
         then
            v_nCurrentMID := r.mid;
            appendToClob (v_lData, v_vBuffer, '"MID'||to_char(r.mid)||'_INSTRUMENT_NAME"'||v_vDelimiter);
         end if;
         
         v_vColumnValue := '"MID'||to_char(r.mid)||'T'||to_char(r.tid)||'Q'||to_char(r.qid)||'R'||to_char(r.rid)||'"';
         appendToClob (v_lData, v_vBuffer, v_vColumnValue||case when (r.rn != v_nLastRownum) then v_vDelimiter end);
      end loop;

      -- add column name header to the export clob
      appendToClob (v_lData, v_vBuffer, chr(13));

      --------------------------------------------------
      -- add data
      --------------------------------------------------
      -- Fetch rows with dbms_sql package.
      while (dbms_sql.fetch_rows (v_nCurID) > 0)
      loop
         -- demo column values and bind
         for i in 1 .. v_nColumnCount 
         loop
            -- set buffer with data
            if (i not in (v_nColumnIndex_PatientID, v_nColumnIndex_IntakeID)) 
            then
               if (v_sDescTab(i).col_type = 2)
               then
                  dbms_sql.column_value (v_nCurID, i, v_nColumnValue);
                  appendToClob (v_lData, v_vBuffer, v_nColumnValue||v_vDelimiter);
               elsif (v_sDescTab(i).col_type = 12)
               then
                  dbms_sql.column_value (v_nCurID, i, v_dColumnValue);
                  appendToClob (v_lData, v_vBuffer, '"'||to_char(v_dColumnValue, v_vDateFormat)||'"'||v_vDelimiter);
               else
                  dbms_sql.column_value (v_nCurID, i, v_vColumnValue);
                  appendToClob (v_lData, v_vBuffer, '"'||v_vColumnValue||'"'||v_vDelimiter);
               end if;
            end if;
         end loop;
         
         -- set patient_id and intake_id
         dbms_sql.column_value (v_nCurID, v_nColumnIndex_PatientID, v_vPatientID);
         dbms_sql.column_value (v_nCurID, v_nColumnIndex_IntakeID, v_nIntakeID);
         
         -- instrument data using patient_id and intake_id
         v_nCurrentMID := 0;
         for r in (select * from vw_utl_rpt_intake_response
                    where instr(v_vDataIncluded,','||mid||',') >= case when (c_nShowNotIncluded = 1) then 0 else 1 end)
         loop
            if (v_nCurrentMID != r.mid)
            then
               v_nCurrentMID := r.mid;
               appendToClob (v_lData, v_vBuffer, '"'||r.module_desc||'"'||v_vDelimiter);
            end if;
            
            -- get intake response value
            if (instr(v_vDataIncluded,','||r.mid||',') > 0)
            then
               v_vColumnValue := responseValue (v_vPatientID, v_nIntakeID, r.mid, r.tid, r.qid, r.rid);
            else
               v_vColumnValue := null;
            end if;

            v_vColumnValue := replace(v_vColumnValue, '"', '""');
            appendToClob (v_lData, v_vBuffer, '"'||v_vColumnValue||'"'||case when (r.rn != v_nLastRownum) then v_vDelimiter end);
         end loop;
         
         -- add row data to the export clob
         appendToClob (v_lData, v_vBuffer, chr(13));
      end loop;

      -- add remaining text
      v_lData := v_lData||v_vBuffer;

      -- add data
      v_vSql := 'update exp_statistical_rpt set status = 2, end_date = sysdate, file_data = :P0 where request_id = :P1 and status = 1';
      execute immediate v_vSql using v_lData, pi_nRequestID;
      commit;

      begin dbms_sql.close_cursor (v_nCurID); exception when others then null; end;
      begin close rc; exception when others then null; end;
      
   exception
      when others
      then
        v_vMsg := sqlerrm;
        
         -- log job failed (-1)
         v_vSql := 'update exp_statistical_rpt set status = -1, end_date = sysdate, status_comment = :P0 where request_id = :P1';
         execute immediate v_vSql using v_vMsg, pi_nRequestID;
         commit;
   end;

   /*Run export*/
   procedure runExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      )
   is
      v_nJobID                             number;
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'Pck_Utl_Export_Data.generateCsv('||pi_nRequestID||','''||pi_vKey||''');';
      sys.dbms_job.submit(job => v_nJobID, what => v_vSql, next_date => sysdate);
      commit;
      
   exception
      when others 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.runExport(): '||sqlErrm;
   end;
   
   /*Cancel export*/
   procedure cancelExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';

      -- set status
      v_vSql := 'update exp_statistical_rpt set status = 3 where request_id = :P1 and status = 1';
      execute immediate v_vSql using pi_nRequestID;
      commit;
      
   exception
      when no_data_found 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.cancelExport(): '||'Export request does not exist!';
      when others 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.cancelExport(): '||sqlErrm;
   end;

end;
/

